/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.extension.internal;

import com.jrockit.mc.common.util.IImageResource;
import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.fields.internal.BooleanField;
import com.jrockit.mc.rjmx.triggers.fields.internal.DateField;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.triggers.fields.internal.FieldHolder;
import com.jrockit.mc.rjmx.triggers.fields.internal.FileField;
import com.jrockit.mc.rjmx.triggers.fields.internal.FloatField;
import com.jrockit.mc.rjmx.triggers.fields.internal.IntegerField;
import com.jrockit.mc.rjmx.triggers.fields.internal.PasswordField;
import com.jrockit.mc.rjmx.triggers.fields.internal.StringField;
import com.jrockit.mc.rjmx.triggers.fields.internal.TimeField;
import com.jrockit.mc.rjmx.triggers.fields.internal.TimeRangeField;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.w3c.dom.Element;

public class TriggerComponent
implements IExecutableExtension,
IImageResource {
    private static final String XML_ATTRIBUTE_ICON = "icon";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_DESCRIPTION = "description";
    private static final String XML_ELEMENT_INTEGER = "integer";
    private static final String XML_ELEMENT_FLOAT = "float";
    private static final String XML_ELEMENT_STRING = "string";
    private static final String XML_ELEMENT_FILE = "file";
    private static final String XML_ELEMENT_BOOLEAN = "boolean";
    private static final String XML_ELEMENT_DATE = "date";
    private static final String XML_ELEMENT_TIME = "time";
    private static final String XML_ELEMENT_TIMERANGE = "timerange";
    private static final String XML_ELEMENT_PASSWORD = "password";
    private static final String XML_FIELD_DESCRIPTION = "description";
    private static final String XML_FIELD_NAME = "name";
    private static final String XML_FIELD_ID = "id";
    private static final String XML_FIELD_DEFAULT_VALUE = "value";
    private static final String XML_FIELD_MIN = "min";
    private static final String XML_FIELD_MAX = "max";
    private static final String XML_SETTINGS_TAG = "settings";
    private String m_description = "";
    private String m_name = "Unknown name";
    private String m_id = "";
    private Resource m_icon;
    private final FieldHolder m_fieldHolder = new FieldHolder();

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (config != null) {
            try {
                this.m_name = this.getAttribute(config, "name", "Unknown name of trigger action");
                this.m_id = this.getAttribute(config, "id", "Unknown name of trigger action");
                this.m_description = this.getAttribute(config, "description", "Unknown name of trigger action");
                if (config != null) {
                    this.m_icon = new Resource(config.getDeclaringExtension().getContributor().getName(), config.getAttribute(XML_ATTRIBUTE_ICON));
                }
                this.addFields(config);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error initializing " + config, e);
            }
        }
    }

    public final void exportToXml(Element parentNode) {
        this.getFieldHolder().exportToXml(parentNode);
    }

    public final void initializeFromXml(Element parentNode) {
        this.getFieldHolder().initializeFromXml(parentNode);
    }

    public FieldHolder getFieldHolder() {
        return this.m_fieldHolder;
    }

    protected String getAttribute(IConfigurationElement ice, String attribute, String defaultValue) {
        String temp;
        if (ice != null && (temp = ice.getAttribute(attribute)) != null) {
            return temp;
        }
        return defaultValue;
    }

    private void addFields(IConfigurationElement ice) throws Exception {
        IConfigurationElement[] ce;
        if (ice == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = ce = ice.getChildren();
        int n = ce.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element != null) {
                try {
                    String fieldDescription = this.getAttribute(element, "description", "");
                    String fieldLabel = this.getAttribute(element, "name", "");
                    String fieldId = this.getAttribute(element, "id", "");
                    String fieldValue = this.getAttribute(element, XML_FIELD_DEFAULT_VALUE, "");
                    Field field = this.createField(element, fieldId, fieldLabel, fieldValue, fieldDescription);
                    if (field != null) {
                        this.m_fieldHolder.addField(field);
                    } else {
                        RJMXPlugin.getDefault().getLogger().severe("Extension XML-parse error " + element.getName());
                    }
                }
                catch (Exception e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Extension XML-parse error " + element.getName(), e);
                }
            }
            ++n2;
        }
    }

    private Field createField(IConfigurationElement ice, String fieldId, String fieldLabel, String fieldValue, String fieldDescription) throws Exception {
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_STRING)) {
            return new StringField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_INTEGER)) {
            String min = this.getAttribute(ice, XML_FIELD_MIN, Integer.toString(Integer.MIN_VALUE));
            String max = this.getAttribute(ice, XML_FIELD_MAX, Integer.toString(Integer.MAX_VALUE));
            return new IntegerField(fieldId, fieldLabel, fieldValue, fieldDescription, min, max);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_FLOAT)) {
            String min = this.getAttribute(ice, XML_FIELD_MIN, Integer.toString(Integer.MIN_VALUE));
            String max = this.getAttribute(ice, XML_FIELD_MAX, Integer.toString(Integer.MAX_VALUE));
            return new FloatField(fieldId, fieldLabel, fieldValue, fieldDescription, min, max);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_FILE)) {
            MCFile defaultFile = IDESupportToolkit.createDefaultFileResource((String)fieldValue);
            return new FileField(fieldId, fieldLabel, defaultFile.getPath(), fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_DATE)) {
            return new DateField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_TIME)) {
            return new TimeField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_BOOLEAN)) {
            return new BooleanField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_TIMERANGE)) {
            return new TimeRangeField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        if (ice.getName().equalsIgnoreCase(XML_ELEMENT_PASSWORD)) {
            return new PasswordField(fieldId, fieldLabel, fieldValue, fieldDescription);
        }
        return null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getDescription() {
        return this.m_description;
    }

    private final String getId() {
        return this.m_id;
    }

    public final String getComponentTag() {
        return XML_SETTINGS_TAG;
    }

    public Resource getImageResource() {
        return this.m_icon;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "[id: " + this.getId() + ']';
    }
}

