/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.internal.Converter;

public class ConversionException
extends QuantityConversionException {
    private static final long serialVersionUID = 1L;
    private final transient Converter<?> converter;
    private final Object prototype;

    public static <T extends Comparable<T>> ConversionException unparsable(String badString, Converter<T> converter, T prototype) {
        return new ConversionException(QuantityConversionException.Problem.UNPARSEABLE, badString, converter, prototype);
    }

    public static <T extends Comparable<T>> ConversionException noUnit(String badString, Converter<T> converter, T prototype) {
        return new ConversionException(QuantityConversionException.Problem.NO_UNIT, badString, converter, prototype);
    }

    public static <T extends Comparable<T>> ConversionException unknownUnit(String badString, Converter<T> converter, T prototype) {
        return new ConversionException(QuantityConversionException.Problem.UNKNOWN_UNIT, badString, converter, prototype);
    }

    public static <T extends Comparable<T>> ConversionException tooLow(String badString, Converter<T> converter, T min) {
        return new ConversionException(QuantityConversionException.Problem.TOO_LOW, badString, converter, min);
    }

    public static <T extends Comparable<T>> ConversionException tooHigh(String badString, Converter<T> converter, T max) {
        return new ConversionException(QuantityConversionException.Problem.TOO_HIGH, badString, converter, max);
    }

    private ConversionException(QuantityConversionException.Problem problem, String badString, Converter<?> converter, Object prototype) {
        super(problem, badString);
        this.converter = converter;
        this.prototype = prototype;
    }

    public String getPersistablePrototype() {
        return this.getPersistablePrototype(this.converter);
    }

    private <T extends Comparable<T>> String getPersistablePrototype(Converter<T> converter) {
        Comparable proto = (Comparable)converter.getType().cast(this.prototype);
        return converter.toConfigString(proto);
    }

    public String getHumanPrototype() {
        return this.getHumanPrototype(this.converter);
    }

    private <T extends Comparable<T>> String getHumanPrototype(Converter<T> converter) {
        Comparable proto = (Comparable)converter.getType().cast(this.prototype);
        return converter.toHuman(proto);
    }
}

