/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.IScalarAffineTransform;
import com.jrockit.mc.common.unit.ImpreciseScaleFactor;
import com.jrockit.mc.common.unit.LongScaleFactor;
import com.jrockit.mc.common.unit.ScaleFactor;

public class DecimalScaleFactor
extends ScaleFactor {
    final int powerOf10;
    private static final char SUPERSCRIPT_MINUS = '\u207b';
    private static final char[] SUPERSCRIPT_DIGITS = "\u2070\u00b9\u00b2\u00b3\u2074\u2075\u2076\u2077\u2078\u2079".toCharArray();

    public static void appendExponentTo(int exp, StringBuilder out) {
        if (exp == 0) {
            out.append(SUPERSCRIPT_DIGITS[0]);
            return;
        }
        if (exp < 0) {
            out.append('\u207b');
            exp = -exp;
        }
        if (exp < 10) {
            out.append(SUPERSCRIPT_DIGITS[exp]);
        } else if (exp < 100) {
            out.append(SUPERSCRIPT_DIGITS[exp / 10]);
            out.append(SUPERSCRIPT_DIGITS[exp % 10]);
        } else {
            char[] orgDigits;
            char[] cArray = orgDigits = Integer.toString(exp).toCharArray();
            int n = orgDigits.length;
            int n2 = 0;
            while (n2 < n) {
                char orgDigit = cArray[n2];
                out.append(SUPERSCRIPT_DIGITS[orgDigit - 48]);
                ++n2;
            }
        }
    }

    public static DecimalScaleFactor get(int powerOf10) {
        if (powerOf10 >= 0) {
            if (powerOf10 < Cache.POS_POWERS.length) {
                return Cache.POS_POWERS[powerOf10];
            }
        } else if (powerOf10 > -Cache.NEG_POWERS.length) {
            return Cache.NEG_POWERS[-powerOf10];
        }
        return new DecimalScaleFactor(powerOf10);
    }

    public static DecimalScaleFactor getSciFloorFactor(double value) {
        return DecimalScaleFactor.get(DecimalPrefix.getFloorLog10(value));
    }

    public static DecimalScaleFactor getEngFloorFactor(double value) {
        return DecimalScaleFactor.get(DecimalPrefix.getFloorLog1000(value) * 3);
    }

    public DecimalScaleFactor(int powerOf10) {
        this.powerOf10 = powerOf10;
    }

    @Override
    public double getMultiplier() {
        return Math.pow(10.0, this.powerOf10);
    }

    public StringBuilder asExponentialStringBuilder(boolean multiplicationSign) {
        StringBuilder out = new StringBuilder(multiplicationSign ? "\u00d710" : "10");
        DecimalScaleFactor.appendExponentTo(this.powerOf10, out);
        return out;
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (this.powerOf10 >= 0) {
            if (srcNumericalValue >= 0L) {
                return (double)srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return (double)srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0L) {
            return this.targetValue(srcNumericalValue) > maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (this.powerOf10 >= 0) {
            if (srcNumericalValue >= 0.0) {
                return srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
            }
            return srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
        }
        if (srcNumericalValue >= 0.0) {
            return this.targetValue(srcNumericalValue) > (double)maxAbsValue;
        }
        return this.targetValue(srcNumericalValue) < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return Math.round((double)srcNumericalValue * this.getMultiplier());
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        return (long)Math.floor((double)srcNumericalValue * this.getMultiplier());
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return this.powerOf10 < 0 ? srcNumericalValue / Math.pow(10.0, -this.powerOf10) : srcNumericalValue * this.getMultiplier();
    }

    @Override
    public boolean isUnity() {
        return this.powerOf10 == 0;
    }

    @Override
    public boolean isInteger() {
        return this.powerOf10 >= 0;
    }

    @Override
    public IScalarAffineTransform chain(IScalarAffineTransform factor) {
        if (factor.isUnity()) {
            return this;
        }
        return this.chain((ScaleFactor)factor);
    }

    @Override
    public ScaleFactor chain(ScaleFactor factor) {
        if (factor.isUnity()) {
            return this;
        }
        if (factor instanceof DecimalScaleFactor) {
            return DecimalScaleFactor.get(this.powerOf10 + ((DecimalScaleFactor)factor).powerOf10);
        }
        return new ImpreciseScaleFactor(factor.targetValue(this.getMultiplier()));
    }

    @Override
    public DecimalScaleFactor invert() {
        return DecimalScaleFactor.get(-this.powerOf10);
    }

    @Override
    public int compareTo(ScaleFactor other) {
        if (other instanceof DecimalScaleFactor) {
            return this.powerOf10 - ((DecimalScaleFactor)other).powerOf10;
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object other) {
        if (this.powerOf10 == 0) {
            return other instanceof ScaleFactor && ((ScaleFactor)other).isUnity();
        }
        return other instanceof DecimalScaleFactor && ((DecimalScaleFactor)other).powerOf10 == this.powerOf10;
    }

    @Override
    public int hashCode() {
        return this.powerOf10;
    }

    private static class Cache {
        private static final DecimalScaleFactor[] POS_POWERS;
        private static final DecimalScaleFactor[] NEG_POWERS;

        static {
            int maxLongPower = (int)Math.floor(Math.log10(9.223372036854776E18));
            DecimalScaleFactor[] posPowers = new DecimalScaleFactor[maxLongPower + 1];
            DecimalScaleFactor[] negPowers = new DecimalScaleFactor[maxLongPower + 1];
            posPowers[0] = negPowers[0] = new Unity();
            long multiplier = 1L;
            int i = 1;
            while (i <= maxLongPower) {
                posPowers[i] = new UpSmall(i, multiplier *= 10L);
                negPowers[i] = new DownSmall(-i, multiplier);
                ++i;
            }
            POS_POWERS = posPowers;
            NEG_POWERS = negPowers;
        }

        private Cache() {
        }
    }

    private static class DownSmall
    extends DecimalScaleFactor {
        private final transient long longDivisor;

        public DownSmall(int powerOf10, long divisor) {
            super(powerOf10);
            assert (powerOf10 < 0);
            assert ((double)powerOf10 > -Math.log10(9.223372036854776E18));
            assert (Math.pow(10.0, -powerOf10) == (double)divisor);
            this.longDivisor = divisor;
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return this.targetValue(srcNumericalValue) > maxAbsValue;
            }
            return this.targetValue(srcNumericalValue) < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue / (this.longDivisor / 2L) + 1L >> 1;
            }
            return ((srcNumericalValue ^ 0xFFFFFFFFFFFFFFFFL) / (this.longDivisor / 2L) ^ 0xFFFFFFFFFFFFFFFFL) + 1L >> 1;
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue / this.longDivisor;
            }
            return (srcNumericalValue ^ 0xFFFFFFFFFFFFFFFFL) / this.longDivisor ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    private static class Unity
    extends DecimalScaleFactor {
        public Unity() {
            super(0);
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue > maxAbsValue;
            }
            return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public double targetValue(double srcNumericalValue) {
            return srcNumericalValue;
        }

        @Override
        public DecimalScaleFactor invert() {
            return this;
        }
    }

    private static class UpSmall
    extends DecimalScaleFactor {
        private final transient long longMultiplier;

        public UpSmall(int powerOf10, long multiplier) {
            super(powerOf10);
            assert (powerOf10 > 0);
            assert ((double)powerOf10 < Math.log10(9.223372036854776E18));
            assert (Math.pow(10.0, powerOf10) == (double)multiplier);
            this.longMultiplier = multiplier;
        }

        @Override
        public ScaleFactor chain(ScaleFactor factor) {
            if (factor.isUnity()) {
                return this;
            }
            if (factor instanceof DecimalScaleFactor) {
                return UpSmall.get(this.powerOf10 + ((DecimalScaleFactor)factor).powerOf10);
            }
            if (factor.isInteger() && !factor.targetOutOfRange(this.longMultiplier, Long.MAX_VALUE)) {
                return new LongScaleFactor(factor.targetValue(this.longMultiplier));
            }
            return new ImpreciseScaleFactor(factor.targetValue(this.getMultiplier()));
        }

        @Override
        public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
            if (srcNumericalValue >= 0L) {
                return srcNumericalValue > maxAbsValue / this.longMultiplier;
            }
            return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.longMultiplier;
        }

        @Override
        public long targetValue(long srcNumericalValue) {
            return this.targetFloor(srcNumericalValue);
        }

        @Override
        public long targetFloor(long srcNumericalValue) {
            if (this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
                return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return srcNumericalValue * this.longMultiplier;
        }
    }
}

