/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.wizards;

import com.jrockit.mc.ui.misc.DisplayToolkit;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SizeConstrainedWizardDialog
extends WizardDialog {
    private static final int DIALOG_MAX_HEIGHT = 700;
    private static final int DIALOG_MIN_HEIGHT = 600;
    private static final int DIALOG_MAX_WIDTH = 800;
    private static final int DIALOG_MIN_WIDTH = 800;
    private Point m_widthContraint = new Point(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private Point m_heightContraint = new Point(Integer.MIN_VALUE, Integer.MAX_VALUE);

    public SizeConstrainedWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setWidthConstraint(800, 800);
        this.setHeightConstraint(600, 700);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateShellSize();
        DisplayToolkit.placeDialogInCenter(this.getParentShell(), this.getShell());
        return control;
    }

    public void setWidthConstraint(int min, int max) {
        this.m_widthContraint = new Point(min, max);
    }

    public void setHeightConstraint(int min, int max) {
        this.m_heightContraint = new Point(min, max);
    }

    protected void updateShellSize() {
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int width = SizeConstrainedWizardDialog.calculateConstrained(this.m_widthContraint.x, size.x, this.m_widthContraint.y);
        int height = SizeConstrainedWizardDialog.calculateConstrained(this.m_heightContraint.x, size.y, this.m_heightContraint.y);
        if (width != size.x || height != size.y) {
            this.getShell().setSize(new Point(width, height));
        }
    }

    private static int calculateConstrained(int min, int preferred, int max) {
        return Math.min(Math.max(min, preferred), max);
    }
}

