/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.preferences;

import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.misc.QuantityKindProposal;
import java.util.LinkedList;
import java.util.logging.Level;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench m_workbench;
    private Button noDefaultRadio;
    private Button wholeRadio;
    private Button timespanRadio;
    private final LinkedList<CheckBox> checkBoxes = new LinkedList();
    private Text timespanValue;
    private Label timespanLabel;

    public GeneralPage() {
        this.setPreferenceStore(FlightRecorderUI.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFERENCES_GENERAL_SETTINGS_TEXT);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Button button = this.createClearButton(container);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        Button removeRecordingsCheckbox = this.createRemoveRecordingsCheckBox(container);
        removeRecordingsCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button confirmRemoveTemplateCheckbox = this.createConfirmRemoveTemplateCheckBox(container);
        confirmRemoveTemplateCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button showMonitoringWarningCheckbox = this.createShowMonitoringWarningCheckBox(container);
        showMonitoringWarningCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Button showHiddenMethodsCheckbox = this.createShowHiddenMethodsCheckBox(container);
        showHiddenMethodsCheckbox.setLayoutData((Object)new GridData(4, 4, false, false));
        Group dumpDefaultGroup = new Group(container, 0);
        dumpDefaultGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        dumpDefaultGroup.setText(Messages.DUMP_RECORDING_DEFAULT_TIMESPAN_TO_DUMP);
        dumpDefaultGroup.setLayout((Layout)new GridLayout());
        this.noDefaultRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.noDefaultRadio.setText(Messages.DUMP_RECORDING_NO_DEFAULT);
        this.wholeRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.wholeRadio.setText(Messages.DUMP_RECORDING_WHOLE);
        this.timespanRadio = new Button((Composite)dumpDefaultGroup, 16);
        this.timespanRadio.setText(Messages.DUMP_RECORDING_TIMESPAN);
        Composite defaultTimespanContainer = new Composite(container, 0);
        defaultTimespanContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        defaultTimespanContainer.setLayout((Layout)new GridLayout(2, false));
        this.timespanLabel = new Label(defaultTimespanContainer, 0);
        this.timespanLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.timespanLabel.setText(Messages.DUMP_RECORDING_TIMESPAN_VALUE);
        this.timespanValue = new Text(defaultTimespanContainer, 2048);
        this.timespanValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        QuantityKindProposal.install((Text)this.timespanValue, (KindOfQuantity)UnitLookup.TIMESPAN);
        this.timespanValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPage.this.validatePage();
            }
        });
        this.loadDumpTypeFromPrefStore(false);
        this.loadTimespanFromPrefStore(false);
        return container;
    }

    private void validatePage() {
        String error = FlightRecorderUI.validateDumpTimespan(this.timespanValue.getText());
        this.setErrorMessage(error);
        this.setValid(error == null);
    }

    private void loadDumpTypeFromPrefStore(boolean loadDefault) {
        int dumpType = loadDefault ? this.getPreferenceStore().getDefaultInt("flightrecorder.controlpanel.default.dump.type") : this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type");
        this.timespanRadio.setSelection(dumpType == 1);
        this.wholeRadio.setSelection(dumpType == 2);
        this.noDefaultRadio.setSelection(dumpType == 0);
    }

    private void loadTimespanFromPrefStore(boolean loadDefault) {
        String timespan = loadDefault ? this.getPreferenceStore().getDefaultString("flightrecorder.controlpanel.default.dump.timespan") : this.getPreferenceStore().getString("flightrecorder.controlpanel.default.dump.timespan");
        this.timespanValue.setText(FlightRecorderUI.parseDumpTimespan(timespan).interactiveFormat());
    }

    private Button createClearButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.PREFERENCES_CLEAR_USER_SETTINGS_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralPage.this.ensureAllEditorsClosed()) {
                    GeneralPage.this.showConfirmUserSettingReset();
                }
            }
        });
        return button;
    }

    private boolean ensureAllEditorsClosed() {
        IEditorReference[] iEditorReferenceArray = this.m_workbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            if ("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor".equals(ref.getId())) {
                this.showMustCloseEditor();
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void showMustCloseEditor() {
        MessageBox messageBox = new MessageBox(this.getShell(), 2);
        messageBox.setMessage(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_OPEN_FLIGHT_RECORDING_DIALOG_TITLE);
        messageBox.open();
    }

    private void showConfirmUserSettingReset() {
        MessageBox messageBox = new MessageBox(this.getShell(), 200);
        messageBox.setMessage(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TEXT);
        messageBox.setText(Messages.PREFERENCES_RESET_USER_SETTINGS_DIALOG_TITLE);
        if (messageBox.open() == 64) {
            ComponentsPlugin.getDefault().getUserInterfaceRepository().clearUserSettings("com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor");
        }
    }

    private Button createRemoveRecordingsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_REMOVE_FINISHED_RECORDING_TEXT, "flightRecorder.removeFinishedRecording");
    }

    private Button createConfirmRemoveTemplateCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_CONFIRM_REMOVE_TEMPLATE_TEXT, "flightRecorder.confirmRemoveTemplate");
    }

    private Button createShowMonitoringWarningCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_SHOW_MONITORING_WARNING_TEXT, "flightrecorder.controlpanel.show.monitoring.warning");
    }

    private Button createShowHiddenMethodsCheckBox(Composite parent) {
        return this.createCheckBox(parent, Messages.PREFERENCES_SHOW_HIDDEN_METHODS_TEXT, "flightRecorder.showHiddenMethods");
    }

    protected void performDefaults() {
        for (CheckBox checkBox : this.checkBoxes) {
            checkBox.setToDefault();
        }
        this.loadDumpTypeFromPrefStore(true);
        this.loadTimespanFromPrefStore(true);
        super.performDefaults();
    }

    private Button createCheckBox(Composite parent, String text, String name) {
        Button checkBox = new Button(parent, 32);
        checkBox.setSelection(this.getPreferenceStore().getBoolean(name));
        checkBox.setText(text);
        this.checkBoxes.add(new CheckBox(checkBox, name));
        return checkBox;
    }

    public boolean performOk() {
        try {
            LinearQuantity timespan = UnitLookup.TIMESPAN.parseInteractive(this.timespanValue.getText());
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.timespan", timespan.persistableString());
        }
        catch (QuantityConversionException qce) {
            FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "JFR preference page should not be closable if dump timespan is not valid", qce);
            return false;
        }
        if (this.timespanRadio.getSelection()) {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 1);
        } else if (this.wholeRadio.getSelection()) {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 2);
        } else {
            this.getPreferenceStore().setValue("flightrecorder.controlpanel.default.dump.type", 0);
        }
        for (CheckBox checkBox : this.checkBoxes) {
            this.getPreferenceStore().setValue(checkBox.m_preference, checkBox.m_button.getSelection());
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.m_workbench = workbench;
    }

    private class CheckBox {
        private final Button m_button;
        private final String m_preference;

        public CheckBox(Button button, String preference) {
            this.m_button = button;
            this.m_preference = preference;
        }

        public void setToDefault() {
            GeneralPage.this.getPreferenceStore().setToDefault(this.m_preference);
            this.m_button.setSelection(GeneralPage.this.getPreferenceStore().getBoolean(this.m_preference));
        }
    }
}

