/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;

final class ArrayParser
implements IParser {
    private final IParser m_elementType;
    private static final int UNREASONABLE_ARRAY_LENGTH = 10000000;

    ArrayParser(IParser elementType) {
        this.m_elementType = elementType;
    }

    public Object[] read(byte[] data, Offset offset) throws InvalidFlrFileException {
        int arraySize = ArrayParser.readArraySize(data, offset.get());
        offset.increase(4);
        Object[] array = new Object[arraySize];
        int n = 0;
        while (n < arraySize) {
            array[n] = this.m_elementType.read(data, offset);
            ++n;
        }
        return array;
    }

    private static int readArraySize(byte[] data, int offset) throws InvalidFlrFileException {
        int length = IntegerParser.readInt(data, offset);
        if (length < 0 || length > 10000000) {
            throw new InvalidFlrFileException();
        }
        return length;
    }
}

