/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.Widget;

public final class CardLayout
implements Layout {
    private static final Point POINT_EMPTY = new Point();
    private static final Rectangle RECTANGLE_EMPTY = new Rectangle();
    private Widget cardLayoutWidget;
    private Widget activeChildWidget;

    public CardLayout(Widget widget) {
        assert (widget != null);
        this.cardLayoutWidget = widget;
        widget.setCheckClipping(true);
    }

    public Widget getActiveChildWidget() {
        return this.activeChildWidget;
    }

    public void setActiveChildWidget(Widget widget) {
        this.activeChildWidget = widget;
        this.cardLayoutWidget.revalidate();
    }

    @Override
    public void layout(Widget widget) {
        assert (widget == this.cardLayoutWidget);
        Point point = null;
        Rectangle rectangle = null;
        if (this.activeChildWidget != null && this.activeChildWidget.isVisible()) {
            for (Widget object2 : this.cardLayoutWidget.getChildren()) {
                if (object2 != this.activeChildWidget) continue;
                point = object2.getPreferredLocation();
                rectangle = object2.getPreferredBounds();
                break;
            }
        }
        if (point == null) {
            point = POINT_EMPTY;
        }
        if (rectangle == null) {
            rectangle = RECTANGLE_EMPTY;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
        for (Widget widget2 : this.cardLayoutWidget.getChildren()) {
            widget2.resolveBounds(point, (Rectangle)(widget2 == this.activeChildWidget ? rectangle : rectangle2));
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return true;
    }

    @Override
    public void justify(Widget widget) {
        assert (widget == this.cardLayoutWidget);
        if (this.activeChildWidget != null && this.activeChildWidget.isVisible()) {
            for (Widget widget2 : this.cardLayoutWidget.getChildren()) {
                if (widget2 != this.activeChildWidget) continue;
                Rectangle rectangle = widget.getClientArea();
                Point point = widget2.getLocation();
                Rectangle rectangle2 = widget2.getBounds();
                rectangle.translate(-point.x, -point.y);
                rectangle2.add(rectangle);
                widget2.resolveBounds(point, rectangle);
                return;
            }
        }
    }
}

