/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class EmbeddedPlanarGraph {
    private MGraph originalGraph;
    private ArrayList<Face> faces;

    public static EmbeddedPlanarGraph createGraph(MGraph mGraph) {
        return new EmbeddedPlanarGraph(mGraph);
    }

    private EmbeddedPlanarGraph(MGraph mGraph) {
        this.originalGraph = mGraph;
        this.faces = new ArrayList();
    }

    public MGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public ArrayList<Face> getFaces() {
        return this.faces;
    }

    public void addFace(Face face) {
        if (!this.faces.contains(face)) {
            this.faces.add(face);
        }
    }

    public void addFaces(Collection<Face> collection) {
        this.faces.addAll(collection);
    }

    public void removeFace(Face face) {
        this.faces.remove(face);
    }

    public void removeFaces(Collection<Face> collection) {
        this.faces.removeAll(collection);
    }

    public Face getOppositeFace(Face face, Face.Dart dart) {
        for (Face face2 : this.faces) {
            if (face2 == face || !face2.containsEdge(dart.getEdge())) continue;
            return face2;
        }
        return null;
    }

    public Face getOuterFace() {
        for (Face face : this.faces) {
            if (!face.isOuterFace()) continue;
            return face;
        }
        return null;
    }
}

