/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.IOException;
import java.net.URL;

public class JARUpdater {
    private JARDesc _jar = null;
    private boolean _updateChecked = false;
    private boolean _updateAvailable = false;

    public JARUpdater(JARDesc jARDesc) {
        this._jar = jARDesc;
    }

    public synchronized boolean isUpdateAvailable() throws Exception {
        if (!this._updateChecked) {
            Trace.println((String)("JARUpdater: update check for " + this._jar.getLocation().toString()), (TraceLevel)TraceLevel.NETWORK);
            try {
                this._updateAvailable = this.updateCheck();
                this._updateChecked = true;
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
                throw exception;
            }
        }
        return this._updateAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Resource downloadUpdate() throws Exception {
        if (this.isUpdateAvailable()) {
            Resource resource = this.download();
            JARUpdater jARUpdater = this;
            synchronized (jARUpdater) {
                this._updateAvailable = false;
            }
            return resource;
        }
        return null;
    }

    private boolean updateCheck() throws JNLPException {
        URL uRL = this._jar.getLocation();
        String string = this._jar.getVersion();
        boolean bl = false;
        if (string != null) {
            return false;
        }
        try {
            bl = ResourceProvider.get().isUpdateAvailable(uRL, string, this.getDownloadType(), null);
        }
        catch (IOException iOException) {
            ResourcesDesc resourcesDesc = this._jar.getParent();
            LaunchDesc launchDesc = resourcesDesc == null ? null : resourcesDesc.getParent();
            throw new FailedDownloadingResourceException(launchDesc, uRL, null, iOException);
        }
        return bl;
    }

    private Resource download() throws JNLPException {
        int n = this.getDownloadType();
        URL uRL = this._jar.getLocation();
        String string = this._jar.getVersion();
        try {
            return ResourceProvider.get().downloadUpdate(uRL, string, n, false);
        }
        catch (IOException iOException) {
            throw new FailedDownloadingResourceException(uRL, string, iOException);
        }
    }

    private int getDownloadType() {
        int n = 256;
        if (this._jar.isNativeLib()) {
            n |= 0x10;
        }
        if (this._jar.isPack200Enabled()) {
            n |= 0x1000;
        }
        return n;
    }
}

